EmployeeRunners.Completed[EmployeeTypeNames.Marketer] =
    EmployeeRunners.Completed[EmployeeTypeNames.DevOps] =
        EmployeeRunners.Completed[EmployeeTypeNames.Developer] =
            EmployeeRunners.Completed[EmployeeTypeNames.Designer] =
                ($rootScope, employee, task) => {
                    $rootScope.settings.inventory[task.component.name] = ($rootScope.settings.inventory[task.component.name] || 0) + 1;
                    $rootScope.$broadcast(GameEvents.InventoryChange);
                    PlaySound(Sounds.produce);

                    let managerWorkstation = GetManagerWorkstationByEmployeeId(employee.id);
                    if (managerWorkstation && task.autoRepeat) {
                        task.state = Enums.TaskStates.Running;
                        return;
                    }

                    task.state = Enums.TaskStates.Stopped;
                };
